<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreModuloRegistrazione extends VisualizzatoreComponente {
        private $configurazioneAspetto;
        private $impostazioni;
        private $datiModuloRegistrazione;
        
        function __construct($db) {
            parent::__construct($db);
            $this->datiModuloRegistrazione = $db->leggiSingolaRiga("geecAd_moduliRegistrazione",1);
        }
        
        function generaContenutoSezione($dati) {
            $impostazioni = parent::getDb()->leggiSingolaRiga("geecAd_impostazioni",1);
            
            ?>
            <div id="login" class="container d-flex">
                <div class="card card-container box-shadow-lite my-4 pt-3 mx-auto" data-aos="fade-down">
                    <div class="text-center">
                        <img class="img-fluid" src="<?php echo $this->configurazioneAspetto["logo"]; ?>"/>
                    </div>

                    <?php 
                        if(isset($_GET["status"])) {
                            if($_GET["status"]==400) {
                                echo"<p class=\"alert alert-danger\">Errore: questa mail è già presente nel database</p>";
                            }
                        }
                        
                        if($impostazioni["registrazioneUtenti"]!="si") {
                            echo"<p class=\"alert alert-warning\">La registrazione degli utenti è disabilitata</p>";
                        }
                        else {
                     ?>
                        <div class="mb-2"><?=  $dati["testo"]  ?></div>
                        <form name="formRegistrazione" action=utenti/eseguiRegistrazione.php method="post">
                        <?php
                            if($this->datiModuloRegistrazione["richiediNome"]=="si") {
                        ?>
                            <div class="form-group">
                                <input type="text" class="form-control" id="exampleInputText1" name="nome" placeholder="Nome">
                            </div>
                        <?php
                            }
                            
                            if($this->datiModuloRegistrazione["richiediCognome"]=="si") {
                        ?>
                          <div class="form-group">
                            <input type="text" class="form-control" id="exampleInputText1" name="cognome" placeholder="Cognome">
                         </div>
                        <?php
                            }
                            
                            if($this->datiModuloRegistrazione["richiediCitta"]=="si") {
                        ?>
                          <div class="form-group">
                            <input type="text" class="form-control" id="exampleInputText1" name="citta" placeholder="Città">
                         </div>
                        <?php
                            }
                            
                            if($this->datiModuloRegistrazione["richiediTelefono"]=="si") {
                        ?>
                          <div class="form-group">
                            <input type="text" class="form-control" id="exampleInputText1" name="telefono" placeholder="Telefono">
                         </div>
                        <?php
                            }
                            
                            if($this->datiModuloRegistrazione["richiediOrganizzazione"]=="si") {
                        ?>
                          <div class="form-group">
                            <input type="text" class="form-control" id="exampleInputText1" name="organizzazione" placeholder="Organizzazione">
                         </div>
                        <?php
                            }
                            
                            if($this->datiModuloRegistrazione["richiediEmail"]=="si") {
                        ?>
                          <div class="form-group">
                            <input type="email" class="form-control" id="exampleInputEmail1" name="email" placeholder="Email">
                          </div>
                        <?php
                            }
                            
                            if($this->datiModuloRegistrazione["richiediPassword"]=="si") {
                        ?>
                          <div class="form-group">
                                <input type="password" class="form-control " name="password" id="exampleInputPassword1" placeholder="Password">
                          </div>
                        <?php
                            }
                            
                            if($this->datiModuloRegistrazione["richiediGruppo"]=="si") {
                                $queryGruppi = "SELECT * FROM geec_gruppi";
                                $risGruppi = parent::getDb()->eseguiQueryLettura($queryGruppi);
                        ?>
                            <div class="form-group">
                                <p>Seleziona il gruppo di appartenzenza</p>
				                
                                <select name=gruppo class="form-control" >
                                <?php 
                                    if($this->datiModuloRegistrazione["gruppoObbligatorio"]!="si") {
                                        ?><option value=0>Nessun gruppo</option><?php
                                    }
                                                    
                                    while($gruppo = $risGruppi->fetch_assoc()) {
                                        echo"<option value={$gruppo["id"]}>{$gruppo["nome"]}</option>";
                                    }
                                ?>
                                </select>
                            </div>
                        <?php
                                }
                        ?>

                          <button type="submit" class="btn btn-primary btn-block" onclick="document.formRegistrazione.submit()">Registrati</button>
                            <?php
                                if($this->impostazioni["accessoFacebook"]=="si") {
                                    include "include/facebookSdk.php";
                            ?>
                                    <fb:login-button scope="public_profile,email" onlogin="checkLoginState();">
                                    </fb:login-button>
                                    <br><br>
                            <?php 
                                }

                                $paginaLogin     = parent::getDb()->leggiSingolaRiga("geecAd_contenuti",$this->impostazioni["paginaLogin"]);
                                $linkPaginaLogin = GeneratoreUrl::creaUrlContenuto($paginaLogin, $this->impostazioni["ottimizzazioneUrl"], $this->impostazioni["urlPiattaforma"]);
                                echo"<div class=\"mt-2\"><a href=\"$linkPaginaLogin\">Hai già un account?</a></div>";
                            }
                        ?>
                    </form>

                </div><!-- /card-container -->
            </div>
            <?php
        }
        
        // getter & setter
        public function getConfigurazioneAspetto() {
            return $this->configurazioneAspetto;
        }

        public function getImpostazioni() {
            return $this->impostazioni;
        }

        public function setConfigurazioneAspetto($configurazioneAspetto) {
            $this->configurazioneAspetto = $configurazioneAspetto;
        }

        public function setImpostazioni($impostazioni) {
            $this->impostazioni = $impostazioni;
        }

    }
